# WeeChat

<p align="center">
  <img src="https://weechat.org/media/images/weechat_logo_large.png" alt="WeeChat" />
</p>

[![Mastodon](https://img.shields.io/badge/mastodon-follow-blue.svg)](https://hostux.social/@weechat)
[![Diaspora*](https://img.shields.io/badge/diaspora*-follow-blue.svg)](https://diasp.eu/u/weechat)
[![X](https://img.shields.io/badge/x-follow-blue.svg)](https://x.com/WeeChatClient)
[![Devel blog](https://img.shields.io/badge/devel%20blog-follow-blue.svg)](https://blog.weechat.org/)
[![Slant](https://img.shields.io/badge/slant-recommend-28acad.svg)](https://www.slant.co/topics/1323/~best-irc-clients-for-linux)
[![Donate](https://img.shields.io/badge/help-donate%20%E2%9D%A4-ff69b4.svg)](https://weechat.org/donate/)

[![CI](https://github.com/weechat/weechat/workflows/CI/badge.svg)](https://github.com/weechat/weechat/actions)
[![Code coverage](https://codecov.io/gh/weechat/weechat/branch/main/graph/badge.svg)](https://codecov.io/gh/weechat/weechat)
[![REUSE status](https://api.reuse.software/badge/github.com/weechat/weechat)](https://api.reuse.software/info/github.com/weechat/weechat)

**WeeChat** (Wee Enhanced Environment for Chat) is a free chat client, fast and light, designed for many operating systems.\
It is highly customizable and extensible with scripts.

Homepage: [https://weechat.org/](https://weechat.org/)

## Features

- **Modular chat client**: WeeChat has a lightweight core and optional [plugins](https://weechat.org/doc/weechat/user/#plugins). All plugins (including [IRC](https://weechat.org/doc/weechat/user/#irc)) are independent and can be unloaded.
- **Multi-platform**: WeeChat runs on GNU/Linux, *BSD, GNU/Hurd, Haiku, macOS and Windows (Bash/Ubuntu and Cygwin).
- **Multi-protocols**: WeeChat is designed to support multiple protocols by plugins, like IRC.
- **Standards-compliant**: the IRC plugin is compliant with RFCs [1459](https://datatracker.ietf.org/doc/html/rfc1459), [2810](https://datatracker.ietf.org/doc/html/rfc2810), [2811](https://datatracker.ietf.org/doc/html/rfc2811), [2812](https://datatracker.ietf.org/doc/html/rfc2812), [2813](https://datatracker.ietf.org/doc/html/rfc2813) and [7194](https://datatracker.ietf.org/doc/html/rfc7194).
- **Small, fast, and very light**: the core is and should stay as light and fast as possible.
- **Customizable and extensible**: there are a lot of options to customize WeeChat, and it is extensible with C plugins and [scripts](https://weechat.org/scripts/) ([Perl](https://weechat.org/scripts/language/perl/), [Python](https://weechat.org/scripts/language/python/), [Ruby](https://weechat.org/scripts/language/ruby), [Lua](https://weechat.org/scripts/language/lua/), [Tcl](https://weechat.org/scripts/language/tcl/), [Scheme](https://weechat.org/scripts/language/guile/), [JavaScript](https://weechat.org/scripts/language/javascript/) and [PHP](https://weechat.org/scripts/language/php/)).
- **Fully documented**: there is comprehensive [documentation](https://weechat.org/doc/weechat/), which is [translated](https://weechat.org/doc/weechat/dev/#translations) into several languages.
- **Developed from scratch**: WeeChat was built from scratch and is not based on any other client.
- **Free software**: WeeChat is released under [GPLv3](https://www.gnu.org/licenses/gpl-3.0.html).

<p align="center">
  <img src="https://weechat.org/media/images/screenshots/weechat/medium/weechat_2013-04-27_phlux_shadow.png" alt="WeeChat" />
</p>

On WeeChat's website you can find [more screenshots](https://weechat.org/about/screenshots/).

## Installation

WeeChat can be installed using your favorite package manager (recommended) or by compiling it yourself.\
For detailed instructions, please check the [WeeChat user's guide](https://weechat.org/doc/weechat/user/#install).

## Semantic versioning

WeeChat is following a "practical" semantic versioning, see file [CONTRIBUTING.md](CONTRIBUTING.md#semantic-versioning).

## Copyright

Copyright © 2003-2025 [Sébastien Helleu](https://github.com/flashcode)

This file is part of WeeChat, the extensible chat client.

WeeChat is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

WeeChat is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with WeeChat.  If not, see <https://www.gnu.org/licenses/>.
